<?php 
$default_options_data = array (
    'soi_alt_value' => '%name %title',
	'soi_title_value' => '',
	'soi_override_alt_value' => '1',
	'soi_override_title_value' => '1',
	'soi_override_thumbnail_images' => '1',
	'soi_exclude_post_type' => '',
	'soi_exclude_post_ids' => '',
	'soi_exclude_post_cat' => '',
	'soi_exclude_post_tags' => '',
	'soi_exclude_page_ids' => '',
	'soi_override_yost_primary_cat' => false,
); 

// If there is no option setting in DB then assign default data to soi option array..
$soi_options_array = wp_parse_args( get_option('soi_options_values') , $default_options_data );
  
if(isset($_POST['submit_general_settings_tab'])){
	$soi_options_array['soi_alt_value'] = esc_attr($_POST['soi_alt_value']);
	$soi_options_array['soi_title_value'] = esc_attr($_POST['soi_title_value']);
	$soi_options_array['soi_override_alt_value'] = esc_attr($_POST['soi_override_alt_value']);
	$soi_options_array['soi_override_title_value'] = esc_attr($_POST['soi_override_title_value']);
	$soi_options_array['soi_override_thumbnail_images'] = esc_attr($_POST['soi_override_thumbnail_images']);
	$soi_options_array['soi_exclude_post_type'] = isset($_POST['soi_exclude_post_type'])?$_POST['soi_exclude_post_type']:'';
	$soi_options_array['soi_exclude_post_ids'] = esc_attr($_POST['soi_exclude_post_ids']);
	$soi_options_array['soi_exclude_post_cat'] = esc_attr($_POST['soi_exclude_post_cat']);
	$soi_options_array['soi_exclude_post_tags'] = esc_attr($_POST['soi_exclude_post_tags']);
	$soi_options_array['soi_exclude_page_ids'] = esc_attr($_POST['soi_exclude_page_ids']);
	$soi_options_array['soi_override_yost_primary_cat'] = esc_attr($_POST['soi_override_yost_primary_cat']);
	update_option ('soi_options_values', $soi_options_array );
}
?>

<div class="wrap settings-wrap" id="page-settings">
    <h2><?php _e('Settings','seo-optimized-images-business') ?></h2>
    <div id="option-tree-header-wrap">
        <ul id="option-tree-header">
            <li id=""><a href="" target="_blank"></a>
            </li>
            <li id="option-tree-version"><span><?php _e('SEO Optimized Images','seo-optimized-images-business') ?></span>
            </li>
        </ul>
    </div>
    <div id="option-tree-settings-api">
    <div id="option-tree-sub-header"></div>
        <div class = "ui-tabs ui-widget ui-widget-content ui-corner-all">
           
          <!-- Tabs Begin-->
            <ul >
                <li id="tab_create_setting"><a href="#section_general"><?php _e('General Settings','seo-optimized-images-business') ?></a></li>
                
			<!--
                <li id="tab_shortcode_atts" ><a href="#shortcode_atts">Shortcode Attributes</a>
                </li>
               <li id="tab_layouts" ><a href="#section_roadmap">RoadMap</a>
                </li> -->
                
                <li id="tab_faq" ><a href="#section_faq"><?php _e('FAQ','seo-optimized-images-business') ?></a>
                </li>
                <li id="tab_support" ><a href="#section_support"><?php _e('Support','seo-optimized-images-business') ?></a>
                </li>
               
               <!--
                <li id="tab_support" ><a href="#get_beta_version">Get the Premium Version</a>
                </li>
                -->
            </ul>
            <!-- Tabs End-->
            
            
    <div id="poststuff" class="metabox-holder">
        <div id="post-body">
			<div id="post-body-content">
                <div id="section_general" class = "postbox">
                    <div class="inside">
                        <div id="setting_theme_options_ui_text" class="format-settings">
                            <div class="format-setting-wrap">
                    
    <div class = "format-setting type-textarea has-desc">
        <div class = "format-setting-inner">            
    <form method="post" action="#section_general">
	<div class="format-setting-label">
		<h3 class="label"><?php _e('General Settings','seo-optimized-images-business') ?></h3>
	</div>
					
    <table class="form-table table_custom">
        
       
        
        <tr valign="top">
        <th scope="row"><?php _e('Alt attribute value','seo-optimized-images-business');?></th>
        <td><input type="text" name="soi_alt_value" value="<?php echo esc_attr( $soi_options_array['soi_alt_value'] ); ?>" />
        <p class=""><?php _e('The Alt attributes will be dynamically replaced by the above value.', 'seo-optimized-images-business') ?></p>
         <p class="">    
             %name - <?php _e('It will insert image name.','seo-optimized-images-business') ?><br> %title- <?php _e('It will insert post title.','seo-optimized-images-business') ?><br>
             %category - <?php _e('It will insert post categories.','seo-optimized-images-business') ?><br> %tags- <?php _e('It will insert post tags.','seo-optimized-images-business') ?>
         </p>
        
        </td>
        </tr>
        
         <tr valign="top">
        <th scope="row"><?php _e('Override existing alt tag','seo-optimized-images-business');?></th>
        <td><select id="soi_override_alt_value" name="soi_override_alt_value">
		<?php $override_setting = array(
		'1'=>__('Yes','seo-optimized-images-business'),
		'0'=>__('No','seo-optimized-images-business')); ?>
		<?php foreach($override_setting as $key => $value) { ?>
		<option value="<?php echo $key; ?>" <?php if ($soi_options_array['soi_override_alt_value']==$key) { echo 'selected="selected"'; } ?>  >
		<?php _e($value,'seo-optimized-images-business') ?> </option>
		<?php } ?>
		</select>
		<p class=""><?php _e('Do you want to override existing alt tags?','seo-optimized-images-business') ?></p>
        </td>
        </tr>
        
       
        
         <tr valign="top">
        <th scope="row"><?php _e('Title attribute value','seo-optimized-images-business');?></th>
        <td><input type="text" name="soi_title_value" value="<?php echo esc_attr( $soi_options_array['soi_title_value'] ); ?>" />
        <p class=""><?php _e('The Title attribute will be dynamically replaced by the above value.', 'seo-optimized-images-business') ?></p>
        
        </td>
        </tr> 
    
       <tr valign="top">
        <th scope="row"><?php _e('Override existing title tag','seo-optimized-images-business');?></th>
        <td><select id="soi_override_title_value" name="soi_override_title_value">
		<?php $override_setting = array(
	    '1'=>__('Yes','seo-optimized-images-business'),
		'0'=>__('No','seo-optimized-images-business')); ?>
		<?php foreach($override_setting as $key => $value) { ?>
		<option value="<?php echo $key; ?>" <?php if ($soi_options_array['soi_override_title_value']==$key) { echo 'selected="selected"'; } ?>  >
		<?php _e($value,'seo-optimized-images-business') ?> </option>
		<?php } ?>
		</select>
		<p class=""><?php _e('Do you want to override existing title tags?','seo-optimized-images-business') ?></p>
        </td>
        </tr>
    
       <tr valign="top">
        <th scope="row"><?php _e('Override alt and title attributes of featured / thumbnail images','seo-optimized-images-business');?></th>
        <td><select id="soi_override_thumbnail_images" name="soi_override_thumbnail_images">
		<?php $override_setting = array(
		'1'=>__('Yes','seo-optimized-images-business'),
		'0'=>__('No','seo-optimized-images-business')); ?>
		<?php foreach($override_setting as $key => $value) { ?>
		<option value="<?php echo $key; ?>" <?php if ($soi_options_array['soi_override_thumbnail_images']==$key) { echo 'selected="selected"'; } ?>  >
		<?php _e($value,'seo-optimized-images-business') ?> </option>
		<?php } ?>
		</select>
		<p class=""><?php _e('Do you want to optimize post / page thumbnail images or want to make seo friendly images?','seo-optimized-images-business') ?></p>
        </td>
        </tr>
		
		<tr valign="top">
			<th scope="row"><?php _e('Exclude post type','seo-optimized-images-business');?></th>
			<td>
			<?php
			$post_type = get_post_types( '', 'names' );
			unset($post_type['revision']);
			unset($post_type['nav_menu_item']);
			foreach ( $post_type as $post_type ) { ?>
				<input type="checkbox" id="soi_exclude_post_type[]" name="soi_exclude_post_type[]" value="<?php echo $post_type; ?>" <?php if(!empty($soi_options_array['soi_exclude_post_type'])){ if(in_array($post_type,$soi_options_array['soi_exclude_post_type'])){ echo 'checked'; } } ?>/><span style="display:inline-block;margin:5px;"><?php echo $post_type; ?></span><br/>
			<?php } ?>
			<p class=""><br/><?php _e('You can select multiple post type to exclude post type.', 'seo-optimized-images-business') ?></p>
			</td>
		</tr>
		
		<tr valign="top">
			<th scope="row"><?php _e('Exclude posts id','seo-optimized-images-business');?></th>
			<td><input type="text" id="soi_exclude_post_ids" name="soi_exclude_post_ids" value="<?php if($soi_options_array['soi_exclude_post_ids']){ echo esc_attr( $soi_options_array['soi_exclude_post_ids'] ); } ?>">
			<p class=""><?php _e('You can enter single or multiple post id like: 1,2,3', 'seo-optimized-images-business') ?></p>
			</td>
		</tr>
		
		<tr valign="top">
			<th scope="row"><?php _e('Exclude categories id','seo-optimized-images-business');?></th>
			<td><input type="text" id="soi_exclude_post_cat" name="soi_exclude_post_cat" value="<?php if($soi_options_array['soi_exclude_post_cat']){ echo esc_attr( $soi_options_array['soi_exclude_post_cat'] ); } ?>">
			<p class=""><?php _e('You can enter single or multiple categories id like: 5,12', 'seo-optimized-images-business') ?></p>
			</td>
		</tr>
		
		<tr valign="top">
			<th scope="row"><?php _e('Exclude tags id','seo-optimized-images-business');?></th>
			<td><input type="text" id="soi_exclude_post_tags" name="soi_exclude_post_tags" value="<?php if($soi_options_array['soi_exclude_post_tags']){ echo esc_attr( $soi_options_array['soi_exclude_post_tags'] ); } ?>">
			<p class=""><?php _e('You can enter single or multiple tags id like: 11,9', 'seo-optimized-images-business') ?></p>
			</td>
		</tr>
		
		<tr valign="top">
			<th scope="row"><?php _e('Exclude pages id','seo-optimized-images-business');?></th>
			<td><input type="text" id="soi_exclude_page_ids" name="soi_exclude_page_ids" value="<?php if($soi_options_array['soi_exclude_page_ids']){ echo esc_attr( $soi_options_array['soi_exclude_page_ids'] ); } ?>">
			<p class=""><?php _e('You can enter single or multiple pages id like: 1,2,3', 'seo-optimized-images-business') ?></p>
			</td>
		</tr>
		
		<tr valign="top">
			<th scope="row"><?php _e('Enable Yoast primary category','seo-optimized-images-business');?></th>
			<td>
				<input type="checkbox" id="soi_override_yost_primary_cat" name="soi_override_yost_primary_cat" value="1" <?php if( $soi_options_array['soi_override_yost_primary_cat'] == true ) echo "checked"; ?>>
				<p class=""><?php _e('Show only primary category created by Yoast SEO Plugin.', 'seo-optimized-images-business') ?></p>
			</td>
		</tr>
		
		</table>
		
		<table class="form-table "> 
		<tr valign="top">
        <td><input type="submit" name="submit_general_settings_tab" value="<?php _e('Save Changes','seo-optimized-images-business'); ?>" class="button button-primary"></td>
        </tr>
		</table>
		
			
			</form>
                                        
					</div>
				</div>
			</div>
         </div>
        </div>
    </div>
    
            
    <div id="section_faq" class = "postbox">
        <div class="inside">
            <div class="format-settings">
                <div class="format-setting-wrap">
                    <div class="format-setting-label">
                    <h3 class="label"><?php _e('How does it work?','seo-optimized-images-business') ?> </h3>
                    </div>
                </div>
            </div>
                                
        <p><span class="description"><?php _e('1. The plugin dynamically replaces the alt tags with the pattern specified by you. It makes no changes to the database.','seo-optimized-images-business') ?>   </span></p>
        <p><span class="description"><?php _e('2. Since there are no changes to the database, one can have different alt tags for same images on different pages/posts.','seo-optimized-images-business') ?></span></p>
        <p><span class="description">3. %name - <?php _e('It will insert image name.','seo-optimized-images-business') ?></span></p>
        <p><span class="description">4. %title- <?php _e('It will insert post title.','seo-optimized-images-business') ?></span></p>
        <p><span class="description">5. %category - <?php _e('It will insert post categories.','seo-optimized-images-business') ?>  </span></p>
        <p><span class="description">6. %tags - <?php _e('It will insert post tags.','seo-optimized-images-business') ?>  </span></p>
        
        </div>
				
				  <div class="inside">
            <div class="format-settings">
                <div class="format-setting-wrap">
                    <div class="format-setting-label">
                    <h3 class="label"> <?php _e('Why optimize alt tags','seo-optimized-images-business') ?> </h3>
                    </div>
                </div>
            </div>
                                
        <p><span class="description"><?php echo sprintf(__('1. According to <a target = "_blank" href = "http://googlewebmastercentral.blogspot.in/2007/12/using-alt-attributes-smartly.html"> this post </a> on the Google Webmaster Blog, Google tends to focus on the information in the ALT text. Creating a optimized alt tags can bring more traffic from Search Engines','seo-optimized-images-business')); ?> </span></p>
        <p><span class="description"><?php _e('2. Take note that the plugin does not make changes to the database. It dynamically replaces the tags at the times of page load.','seo-optimized-images-business') ?></span></p>
                      
				</div>
				
				
	</div>
	
	
	  <div id="section_support" class = "postbox">
        <div class="inside">
            <div class="format-settings">
                <div class="format-setting-wrap">
                    <div class="format-setting-label">
                    <h3 class="label"><?php _e('Support','seo-optimized-images-business') ?> </h3>
                    </div>
                </div>
            </div>
                                
        <p><span class="description"><?php echo sprintf(__('1. For any queries contact us via the <a href="http://webriti.com/support/" target = "_blank"> support forums </a>','seo-optimized-images-business')); ?></span></p>
        <p><span class="description"><?php echo sprintf(__('2. If you like our plugin and support than kindly share your <a href = "https://wordpress.org/support/view/plugin-reviews/seo-optimized-images" target = "_blank"> feedback </a> Your feedback is valuable.','seo-optimized-images-business')); ?></span></p>
                      
				</div>
	</div>

	
        </div>
    </div>
    </div>
        <div class="clear"></div>
        </div>
    </div>
</div>
