<?php 
include(get_stylesheet_directory() . '/includes/temp-field-types.php');

include(get_template_directory() . '/inc/core-post-types.php');
include(get_template_directory() . '/inc/core-dashboards.php');
include(get_template_directory() . '/inc/core-pagination.php');
include(get_template_directory() . '/inc/core-permission.php');
include(get_template_directory() . '/inc/core-conversion.php');
include(get_template_directory() . '/inc/core-field-types.php');

// Define Toggles Display - Home Page 
function home_settings() {
  $settings_map = array(
    'home_banner'  => '582d958db59d2',
    'home_profile' => '584900c9d464c',
    'home_feature' => '5849005ed4646',
    'home_service' => '588b6a74cdeea',
    'home_inquiry' => '584901c6d4657',
    'home_actions' => '377c9cd6956b0',
    'home_gallery' => '5877b3ec24f4c',
    'home_clients' => '591c9cd6272b0',
    'home_recent'  => '588b6a72cdee9',
    'home_badges'  => '58f4fd35bf13f',
  );

  if(is_admin() && have_rows('home_layout', 'option') ){
    foreach($settings_map as $row_name => $field_id){
      ${$row_name} = false;
    }

    while (have_rows('home_layout', 'option')){
      the_row();
      $row_name = get_row_layout();
      if(in_array($row_name, array_keys($settings_map))) {
        ${$row_name} = true;
      }
    }

    foreach($settings_map as $row_name => $field_id){
      if(!${$row_name}){
        echo '<style>a[data-key="field_'. $field_id .'"]{display:none !important;}</style>';
      }
    }   
  }
}
add_action('admin_head', 'home_settings');

if( function_exists('acf_add_local_field_group') ){

  $field_group = array(
    'key' => 'group_5988a08c06085',
    'title' => 'Home Layout',
    'fields' => array (
      array (
        'key' => 'field_5988a08ecd80c',
        'label' => 'Home Layout',
        'name' => 'home_layout',
        'type' => 'flexible_content',
        'instructions' => '',
        'required' => 0,
        'conditional_logic' => 0,
        'wrapper' => array (
          'width' => '',
          'class' => '',
          'id' => '',
        ),
        'layouts' => array (),
        'button_label' => 'Add Row',
        'min' => '',
        'max' => '',
      ),
    ),
    'location' => array (
      array (
        array (
          'param' => 'options_page',
          'operator' => '==',
          'value' => 'theme-control-settings',
        ),
      ),
    ),
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => 1,
    'description' => '',
  );

  $layout_map = array(
    '5988a093983d6' => 'home-banner.php',
    '5988a0bacd80e' => 'home-feature.php',
    '5988a0b7cd80d' => 'home-profile.php',
    '5988a147cd80f' => 'home-service.php',
    '5988a15ccd812' => 'home-inquiry.php',
    '5988a149cd810' => 'home-actions.php',
    '59a07cdf8a063' => 'home-gallery.php',
    '5988a15acd811' => 'home-clients.php',
    '5988a16ecd813' => 'home-recent.php',
    '5988a179cd814' => 'home-badges.php',
  );

  $layouts = array(
    '5988a093983d6' => array (
      'key' => '5988a093983d6',
      'name' => 'home_banner',
      'label' => 'Banner',
      'display' => 'block',
      'sub_fields' => array (),
      'min' => '',
      'max' => '',
    ),
    '5988a0bacd80e' => array (
      'key' => '5988a0bacd80e',
      'name' => 'home_feature',
      'label' => 'Feature',
      'display' => 'block',
      'sub_fields' => array (),
      'min' => '',
      'max' => '',
    ),
    '5988a0b7cd80d' => array (
      'key' => '5988a0b7cd80d',
      'name' => 'home_profile',
      'label' => 'Profile',
      'display' => 'block',
      'sub_fields' => array (),
      'min' => '',
      'max' => '',
    ),
    '5988a147cd80f' => array (
      'key' => '5988a147cd80f',
      'name' => 'home_service',
      'label' => 'Service',
      'display' => 'block',
      'sub_fields' => array (),
      'min' => '',
      'max' => '',
    ),
    '5988a15ccd812' => array (
      'key' => '5988a15ccd812',
      'name' => 'home_inquiry',
      'label' => 'Inquiry',
      'display' => 'block',
      'sub_fields' => array (),
      'min' => '',
      'max' => '',
    ),
    '5988a149cd810' => array (
      'key' => '5988a149cd810',
      'name' => 'home_actions',
      'label' => 'Actions',
      'display' => 'block',
      'sub_fields' => array (),
      'min' => '',
      'max' => '',
    ),
    '59a07cdf8a063' => array (
      'key' => '59a07cdf8a063',
      'name' => 'home_gallery',
      'label' => 'Gallery',
      'display' => 'block',
      'sub_fields' => array (),
      'min' => '',
      'max' => '',
    ),
    '5988a15acd811' => array (
      'key' => '5988a15acd811',
      'name' => 'home_clients',
      'label' => 'Clients',
      'display' => 'block',
      'sub_fields' => array (),
      'min' => '',
      'max' => '',
    ),
    '5988a16ecd813' => array (
      'key' => '5988a16ecd813',
      'name' => 'home_recent',
      'label' => 'Recent',
      'display' => 'block',
      'sub_fields' => array (),
      'min' => '',
      'max' => '',
    ),
    '5988a179cd814' => array (
      'key' => '5988a179cd814',
      'name' => 'home_badges',
      'label' => 'Badges',
      'display' => 'block',
      'sub_fields' => array (),
      'min' => '',
      'max' => '',
    ),
  );

  $file_base = get_stylesheet_directory() . '/sections/';

  foreach($layouts as $key => $data){
    if(array_key_exists($key, $layout_map) && file_exists($file_base . $layout_map[$key])){
      $field_group['fields'][0]['layouts'][$key] = $data;
    }
  }
  acf_add_local_field_group($field_group);
}

// Define Toggles Display - Post Types
function type_settings() {
  if(is_admin() && get_field('recent_type_toggle', 'option') == false) {
    echo '<style>#menu-posts{display:none !important;}#wp-admin-bar-new-post{display:none !important;}</style>'; 
  }
  if(is_admin() && get_field('service_type_toggle', 'option') == false) {
    echo '<style>#menu-posts-service{display:none !important;}#wp-admin-bar-new-service{display:none !important;}</style>'; 
  }
  if(is_admin() && get_field('gallery_type_toggle', 'option') == false) {
    echo '<style>#menu-posts-gallery{display:none !important;}#wp-admin-bar-new-gallery{display:none !important;}</style>'; 
  }  
  if(is_admin() && get_field('clients_type_toggle', 'option') == false) {
    echo '<style>#menu-posts-testimonial{display:none !important;}#wp-admin-bar-new-testimonial{display:none !important;}</style>'; 
  }
  if(is_admin() && get_field('member_type_toggle', 'option') == false) {
    echo '<style>#menu-posts-team{display:none !important;}#wp-admin-bar-new-team{display:none !important;}</style>'; 
  }
}
add_action('admin_head', 'type_settings');

// Clear All Caches (64mb)
if (class_exists('autoptimizeCache')) {
    $myMaxSize = 48000; 
    $statArr=autoptimizeCache::stats(); 
    $cacheSize=round($statArr[1]/1024);
    if ($cacheSize>$myMaxSize){
       autoptimizeCache::clearall();
    if( class_exists('W3_Plugin_TotalCacheAdmin') )
    {
        $plugin_totalcacheadmin = & w3_instance('W3_Plugin_TotalCacheAdmin');
        $plugin_totalcacheadmin->flush_all();
    }
       header("Refresh:0"); 
    }
}

// Define Menu Locations
function register_menu() {
  register_nav_menus(
  array( 'mainnav' => __( 'Main Menu' ),
         'footnav' => __( 'Foot Menu' ),
  ) ); }
add_action( 'init', 'register_menu' );  

// Featured Image Support
add_theme_support( 'post-thumbnails');

// Remove W3TC Commenting
add_filter( 'w3tc_can_print_comment', '__return_false', 10, 1 );

// Remove WP Notification
add_action('after_setup_theme','remove_core_updates');
function remove_core_updates() {
if(! current_user_can('update_core')){return;}
add_action('init', create_function('$a',"remove_action( 'init', 'wp_version_check' );"),2);
add_filter('pre_option_update_core','__return_null');
add_filter('pre_site_transient_update_core','__return_null');
}

// Conditonall CSS Formats
function conditional_css( $classes ) {
    if ( have_rows('social_networks','option') || get_field('notification','option') ) { $classes[] = 'social'; }
    return $classes;
}  
add_filter( 'body_class','conditional_css' );

function remove_img_link() {
  $image_set = get_option( 'image_default_link_type' );
  if ($image_set !== 'none') {
    update_option('image_default_link_type', 'none');
  }
}
add_action('admin_init', 'remove_img_link', 10);
