<?php 

	$color    		= get_field('accent', 'option');
	$second   		= get_field('second', 'option');
	$rgba5    		= hex2rgba($color, 0.5); 
	$rgba6    		= hex2rgba($color, 0.6); 
	$rgba7    		= hex2rgba($color, 0.7); 
	$rgba8    		= hex2rgba($color, 0.8); 
	$rgba9    		= hex2rgba($color, 0.9);

	function darken_color($rgb, $darker=2) {

		$hash = (strpos($rgb, '#') !== false) ? '#' : '';
		$rgb = (strlen($rgb) == 7) ? str_replace('#', '', $rgb) : ((strlen($rgb) == 6) ? $rgb : false);
		if(strlen($rgb) != 6) return $hash.'000000';
		$darker = ($darker > 1) ? $darker : 1;

		list($R16,$G16,$B16) = str_split($rgb,2);

		$R = sprintf("%02X", floor(hexdec($R16)/$darker));
		$G = sprintf("%02X", floor(hexdec($G16)/$darker));
		$B = sprintf("%02X", floor(hexdec($B16)/$darker));

		return $hash.$R.$G.$B; }

	$darker = darken_color($color);

?>

<style type=text/css >  

/*------------------- Accent Color -------------------*/

	a { color: <?php echo $color; ?>; }
	a:focus,a:hover{ color: <?php echo $second; ?>; }
	a.continue, a.more { color: <?php echo $color; ?>; }

	.btn { background: <?php echo $color; ?>; }
	.btn.reverse { background: <?php echo $second; ?>; }

	.main-nav { background: <?php echo $color; ?>; }
	.c-button { color:<?php echo $color; ?>; }
	ul.slimmenu li ul li {background:<?php echo $second; ?>;border-color:<?php echo $second; ?>; }
	ul.slimmenu li.has-submenu ul li a {background: <?php echo $color; ?>;}
	.page-nav ul li:first-child:before { color: <?php echo $color; ?>;}
	.page-nav ul li a:hover, .page-nav ul li a:focus { color: <?php echo $color; ?>; }
	.side-nav ul li:before { background: <?php echo $color; ?>; }

	.slider-des .btn { background: <?php echo $second; ?>; }
	.slider-des .btn.hvr-sweep-to-right:before { background: <?php echo $color; ?>; }

	.news-list figure .date { background: <?php echo $color; ?>; }
	.news-list .text h4 a:hover, .news-list .text h4 a:focus { color: <?php echo $second; ?>; }
	.content-right .news-list .block h2 a:hover, .content-right .news-list .block h2 a:focus { color: <?php echo $color; ?>; }
	.recent-posts ul li p a:hover, .recent-posts ul li p a:focus { color: <?php echo $color; ?>; }

	.copy-rights .scrollup.hvr-icon-bob:before { color: <?php echo $color; ?>; }

	.contact-form.content-form .frm_style_formidable-style.with_frm_style.frm_login_form label { color: <?php echo $color; ?> !important; }
	.contact-form.content-form .frm_style_formidable-style.with_frm_style .frm_required { color: <?php echo $color; ?> !important; }
	.contact-form.content-form  .frm_style_formidable-style.with_frm_style .chosen-container-active .chosen-choices { border-color: <?php echo $color; ?> !important; background-color: #fff !important;}
	.frm_submit input { background: <?php echo $color; ?> !important; border: 0 !important; }

	.more:hover, .more:focus, .continue:hover, .continue:focus { color: <?php echo $color; ?>; }
	.list li:before, .list-arrow li:before, .list-bullet li:before { color: <?php echo $color; ?>; }
	.list-bullet li:hover:before { color: <?php echo $color; ?>;}
	.call-today h6 a:hover, .call-today h6 a:focus { color: <?php echo $color; ?>;}

	.profile .title span { color: <?php echo $color; ?>; }
	.service .block:hover .des { background: <?php echo $color; ?>;}
	.clients .icon { color: <?php echo $color; ?>; border: 2px solid <?php echo $color; ?>;}
	.content-left .clients h6 { color: <?php echo $color; ?>; }
	.project-block .block:hover h4 { color: <?php echo $color; ?>; }

	footer a { color: <?php echo $color; ?>; }
	footer .phone .hvr-icon-pop { color: <?php echo $color; ?>; }
	.block .fa { color: <?php echo $color; ?>; }
	.call-today .fa { color: <?php echo $color; ?>; border: 2px solid <?php echo $color; ?>; }
	.menu-list ul li a { background: <?php echo $color; ?>; }
	.partner { background: <?php echo $color; ?>; }
	.actions { background: <?php echo $color; ?>; }
	.actions .btn.reverse:hover { color: <?php echo $color; ?>; }
	.btn.reverse.hvr-sweep-to-right:before { background: <?php echo $color; ?>;}

	.testimonial { border-left: 5px solid <?php echo $color; ?>; }

/*------------------- Second Color -------------------*/

	ul.slimmenu li.has-submenu ul li a:focus,ul.slimmenu li.has-submenu ul li a:hover {background: <?php echo $second; ?>;}
	.title:before, .title-small:before { background: <?php echo $second; ?>; }
	.btn.yellow { background-color: <?php echo $second; ?>; }
	.service .block:hover .des .list li:before { color: <?php echo $second; ?>; }
	.service .block .des h3 a:hover { color: <?php echo $second; ?>; }
	.contact-form .frm_style_formidable-style.with_frm_style .chosen-container-active .chosen-choices { border-color:  <?php echo $second; ?>; }
	.feature .fa { color: <?php echo $second; ?>; }
	.top { background: <?php echo $second; ?>; }
	ul.slimmenu li a.hvr-underline-from-center:before { background:  <?php echo $second; ?>; }
	footer .phone span a:hover, footer .phone span a:focus { color: <?php echo $second; ?>; }
	footer .social a:hover, footer .social a:focus { color: <?php echo $second; ?>; }
	footer .list-arrow li:hover a, footer .list-arrow li:hover:before { color: <?php echo $second; ?>; }   
	header.sticky .header-block { border-top: 5px solid <?php echo $second; ?>; }
	.btn.hvr-sweep-to-right:before { background-color: <?php echo $second; ?>; }
	.btn.submit:hover, .btn.submit:focus { background-color: <?php echo $second; ?>; }
	.get-appointment { background: <?php echo $second; ?>; }
	.contact-form .btn:hover, .contact-form .btn:focus { background-color: <?php echo $second; ?>; }
	.frm_submit input:hover, .frm_submit input:focus { background-color:  <?php echo $second; ?> !important; border: 0 !important; }
	.clients .des p:before { background: <?php echo $second; ?>; }
	.slick-next,.slick-next:focus,.slick-next:hover,.slick-prev,.slick-prev:focus,.slick-prev:hover{ color: <?php echo $second; ?>; }
	.testimonial-icon { color: <?php echo $second; ?>; }
 
/*------------------- Media Queries -------------------*/

	@media only screen and (max-width:1200px) {.c-menu { background-color: <?php echo $color; ?>; }ul.slimmenu li .sub-toggle{background:<?php echo $second; ?>;}}
	@media only screen and (max-width: 767px) { social .header-block { border-top:5px solid <?php echo $second ?>; } }

</style>