<?php
/* Template Name: Post Page */

get_header();
?>

<section class="inner-banner">
    <?php $cat_title = get_the_category(); ?>

    <figure class="image-fill">
        <img src="<?php bloginfo('template_directory');?>/images/inner-banner.jpg" alt="">
    </figure>

    <div class="container">
        <h1><?php echo $cat_title[0]->name; ?></h1>

        <div class="page-nav">
            <ul>
                <li><a href="<?php bloginfo('url'); ?>">Home</a></li>
                <li><?php echo $cat_title[0]->name; ?></li>
            </ul>
        </div>
    </div>
</section>

<section class="content-block">
    <div class="container">
        <div class="row">
            <div class="col-md-9 col-sm-8 content-right main-content">
                <div class="news-list">
                    <?php
                    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                    $custom_args = array(
                    'post_type'       =>    'post',
                    'posts_per_page'  =>    5,
                    'paged'           =>    $paged
                    );

                    $custom_query = new WP_Query($custom_args);
                    ?>

                    <?php if ($custom_query->have_posts()) : while ($custom_query->have_posts()) : $custom_query->the_post(); ?>
                        <div class="block">
                            <figure class="image-fill">
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_post_thumbnail('large'); ?>
                                </a>
                            </figure>

                            <div class="text">
                                <h2>
                                    <a href="<?php the_permalink(); ?>">
                                        <?php the_title();?>
                                    </a>
                                </h2>

                                <div class="time">
                                    <?php the_time('M') ?><?php the_time('d') ?>, <?php the_time('Y') ?>
                                </div>

                                <?php $content = get_the_content(); echo substr($content, 0,150); ?>

                                <div class="clear"></div>

                                <a href="<?php the_permalink(); ?>" class="continue">Continue Reading</a>
                            </div>
                        </div>
                    <?php endwhile; wp_reset_postdata(); ?>

                    <?php
                        if (function_exists(custom_pagination)) {
                            custom_pagination($custom_query->max_num_pages, "", $paged);
                        }

                        wp_reset_postdata();
                    else :
                        _e( 'Sorry, no posts matched your criteria.' );
                    endif;
                    ?>
                </div>
            </div>

            <div class="col-md-3 col-sm-4 content-left">
                <div class="recent-posts">
                    <div class="title-small"> Recent Posts </div>
                    
                    <ul>
                        <?php
                        $args = array('numberposts' => 5);
                        $lastposts = get_posts($args);

                        foreach ($lastposts as $post) : setup_postdata($post);
                        ?>
                            <li>
                                <figure class="image-fill">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php the_post_thumbnail('thumbnail'); ?>
                                    </a>
                                </figure>
                                
                                <p>
                                    <a href="<?php the_permalink(); ?>">
                                        <?php the_title(); ?>
                                    </a>
                                </p>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>