<!DOCTYPE html>

<html lang="en">

<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/png" href="<?php the_field('favicon', 'option'); ?>">
    <?php the_field('ca_tracking', 'option') ?>
    <?php the_field('cs_header', 'option') ?>
    <?php wp_head(); ?>
    <?php include("assets/css/color-picker.php"); ?>
    <?php include(get_template_directory() . '/inc/core-schema.php'); ?>
    <style><?php $custom=get_field('custom', 'option', false, false); echo $custom; ?></style>
</head>

<body <?php body_class(); ?>>
    <div id="o-wrapper" class="o-wrapper">
        <div id="c-mask" class="c-mask"></div>
        <header class="navigation">
            <div class="top">
                <div class="container">
                    <?php if( get_field('notification', 'option') ): ?>
                    <div class="notification">
                        <?php the_field('notification', 'option'); ?>
                    </div>
                    <?php endif; ?>
                    <?php if ( have_rows( 'social_networks', 'option' ) ) : ?>
                    <div class="social-icons">
                        <?php while ( has_sub_field( 'social_networks', 'option' ) ) : $url = get_sub_field( 'social_link' ); ?>
                        <?php if ( !empty( $url ) ) : ?>
                        <a href="<?php echo $url; ?>" target="_blank">
                            <i class="fab fa-<?php the_sub_field( 'social_title' ); ?>"></i>
                        </a>
                        <?php endif; ?>
                        <?php endwhile; ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="header-block">
                <div class="container">
                    <div class="logo">
                        <a href="<?php bloginfo( 'url' ); ?>"><img class="no-cache" src="<?php the_field( 'company_logo', 'option' ); ?>" alt="<?php wp_title(''); ?>"></a>
                    </div>
                    <div class="header-right">
                        <div class="call-today">
                            <i class="fa fa-map-marker-alt" aria-hidden="true"></i> 
                            <h6>
                                <span class="phone">Call</span>
                                <a href="tel:<?php the_field( 'company_phone', 'option' ); ?>">
                                    <?php the_field( 'company_phone', 'option' ); ?>
                                </a>
                                <?php $contact_address = get_field( 'company_address', 'option' ); ?>
                                <?php echo "<span>".$contact_address['address']."</span>"; ?>
                            </h6>
                        </div>
                        <button id="c-button-slide-right" class="c-button">
                            <i class="fa fa-bars"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="main-nav">
                <div class="container">
                    <div class="nav-m">
                        <nav id="c-menu-slide-right" class="c-menu c-menu-slide-right">
                            <button class="c-menu-close">Close Menu &rarr;</button>
                            <?php
                            wp_nav_menu(
                                array(
                                'theme_location'  =>  'mainnav',
                                'container'       =>  'ul',
                                'menu_class'      =>  'slimmenu',
                                'depth'           =>  5
                                ) );
                            ?>
                        </nav>
                    </div>
                    <?php $button = get_field( 'header_button_link', 'option' ); ?>
                    <a href="<?php echo $button['url']; ?>" class="get-appointment">
                        <?php echo $button['title']; ?>
                    </a>
                </div>
            </div>
        </header>
    </div>