<?php if (get_field('plan_type', 'option') == '05 Page') { wp_redirect( '/services', 301 ); } else { ?>
  <?php get_header(); ?>
  <?php get_template_part('templates/page-header'); ?>

  <section class="content-block">
    <div class="container">
      <div class="row">
        <div class="col-md-3 col-sm-4 content-left sidebar">
          <div class="menu-list">
            <ul>
              <?php if (get_field('plan_type', 'option') == '10 Page') {
                $custom_post_type = 'service';
                $terms = get_the_terms( $post->ID , 'service_type' );

                foreach( $terms as $term ) { $name = $term->slug; }

                if( has_term( '', 'service_type' ) ) {

                $args=array(
                  'post_type' => $custom_post_type,
                  'post_status' => 'publish',
                  'posts_per_page' => -1,
                  'caller_get_posts'=> 1,
                  'tax_query' => array(
                    array(
                        'taxonomy' => 'service_type',
                        'field'    => 'slug',
                        'terms'    => array($name)
                    ),
                  ),
                );

              } elseif ( !has_term( '', 'service_type' ) ){
                $args = array(
                  'post_type' => $custom_post_type,
                  'post_status' => 'publish',
                  'posts_per_page' => -1,
                  'caller_get_posts'=> 1
                );
            }

              $my_query = new WP_Query($args);

              if ( $my_query -> have_posts() ) {
                $i=1;

                while ( $my_query -> have_posts() ) : $my_query -> the_post(); ?>
                  <li><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
                <?php endwhile; } wp_reset_query(); }

              elseif (get_field('plan_type', 'option') == '05 Page') {
                wp_nav_menu(
                    array(
                        'menu' => 'Main Menu',
                        'depth' => 1,
                    )
                );
              } ?>
              </ul>
            </div>

            <?php get_template_part( 'sections/sidebar-forms' ); // test ?>
          </div>

            <div class="col-md-9 col-sm-8 content-right main-content">
              <?php if ( has_post_thumbnail() ){ ?>
                <figure class="image-fill"><?php the_post_thumbnail('medium_large'); ?></figure>
              <?php } ?>

              <?php the_content();?>

              <?php if ( have_rows('service_listing') ): ?>
                <div class="services">
                  <ul>
                    <?php while(has_sub_field('service_listing')): ?>
                      <li>
                        <?php if ( get_sub_field('service_list_title') ) : ?>
                          <h6><?php the_sub_field('service_list_title')?></h6>
                        <?php endif; ?>

                        <?php the_sub_field('service_list_item')?>
                      </li>
                    <?php endwhile; ?>
                  </ul>
                </div>
              <?php endif; ?>

              <?php
                    $image_ids = get_field('service_gallery', false, false);
                    if(!empty($image_ids)){
                        $shortcode = '[gallery ids="' . implode(',', $image_ids) . '"]';
                        echo do_shortcode( $shortcode );
                    }
              ?>
      </div>
    </div>
  </div>
</section>

<?php get_footer(); ?>

<?php } ?>