<?php
/* Template Name: Contact Page */

get_header();
get_template_part('templates/page-header');
?>

<section class="content-block">
    <div class="container">
        <div class="row">
            <div class="col-md-3 col-sm-4 content-left sidebar">
                <?php get_template_part( 'sections/sidebar-menu' ); ?>
            </div>

            <div class="col-md-9 col-sm-8 content-right main-content">
                <?php the_content();?>
            </div>
        </div>
    </div>
</section>

<div id="map-block">
    <?php
    $location = get_field('company_address', 'option');

    if ( !empty($location) ) :
        echo '<div class="acf-map">';
            echo '<div class="marker" data-lat="' . $location['lat'] . '" data-lng="' . $location['lng'] . '"></div>';
        echo '</div>';
    endif;
    ?>
</div>

<?php get_footer(); ?>
