<?php /* Template Name: Gallery Page */ ?>

<?php get_header(); ?>

<?php get_template_part('templates/page-header'); ?>

    <section class="content-block">

        <div class="container">

                <main class="cd-main-content">

                    <div class="cd-tab-filter-wrapper">

                        <div class="cd-tab-filter">

                            <?php $taxonomy = 'gallery_type';

                            $terms = get_terms($taxonomy); // Get all terms of a taxonomy

                            if ( $terms && !is_wp_error( $terms ) ) : ?>

                            <ul class="cd-filters">

                                <li class="filter"><a class="selected" data-type="all">All</a></li>

                                <?php foreach ( $terms as $term ) { $final = str_replace(' ','_',$term->name); ?>

                                <li class="filter" data-filter=".<?php echo $final; ?>"><a data-type="<?php echo $final; ?>"><?php echo $term->name; ?></a></li>

                                <?php } ?>

                            </ul>

                            <?php endif;?>

                        </div>

                    </div>

                    <div class="row">

                    <div class="main-content">
                      
                    <div class="project-block cd-gallery">

                        <ul>

                            <?php

                            $custom_post_type = 'gallery';

                            $args=array(

                            'post_type' => $custom_post_type,

                            'post_status' => 'publish',

                            'posts_per_page' => -1,

                            'caller_get_posts'=> 1,
                            
                            'orderby'   => 'title',
                            
                            'order' => 'ASC'

                            );

                            $my_query = null;

                            $my_query = new WP_Query($args);

                            if( $my_query->have_posts() ) {

                            $i=1;

                            while ($my_query->have_posts()) : $my_query->the_post(); ?>

                            <?php $id = get_the_ID();
                              
                                  $terms = get_the_terms($id, 'gallery_type' );

                            if ( $terms && ! is_wp_error($terms) ) :
                              
                                $names = array();

                                foreach ($terms as $term) { $names[] = $term->name; }

                                $term_slugs = join(', ', $names);
                              
                                $joined_names = join(';', $names);
                              
                                $no_spaces = str_replace(' ', '_', $joined_names);
                              
                                $final = str_replace(';', ' ', $no_spaces);

                            endif; ?>                      
                      
                            <li class="col-md-4 col-sm-4 col-xs-6 block mix <?php echo $final; ?>">
                              
							    <?php if (get_field('gallery_type') == 'external') { ?>
                              
                                <?php $link = get_field('gallery_link'); ?>
                              
                                <a href="<?php echo $link ?>" target="_blank" alt="<?php the_title(); ?>">
                              
							    <?php } else if (get_field('gallery_type') == 'image') { ?>
                              
                                <?php $image = get_field('gallery_image'); $size = 'medium'; ?>
                                  
                                <?php $gallery_link = wp_get_attachment_image_url( $image, $full ); ?>
                                                                        
                                <a rel="lightbox" data-rel=”lightbox-gallery-100” href="<?php echo $gallery_link; ?>"> 
                                    
                                <?php } else if (get_field('gallery_type') == 'video') { ?>
                                    
                                <a rel="lightbox" data-rel=”lightbox-gallery-100” href="https://www.youtube-nocookie.com/embed/<?php the_field('gallery_video') ?>?rel=0"> 

								<?php } ?>                               

										<figure class="image-fill">

											<?php if (get_field('gallery_type') == 'image' || get_field('gallery_type') == 'external') { ?>

											    <?php echo wp_get_attachment_image( $image, $size ); ?>

											<?php } else if (get_field('gallery_type') == 'video') { ?>

										        <iframe width="100%" height="100%" src="https://www.youtube-nocookie.com/embed/<?php the_field('gallery_video') ?>?rel=0" frameborder="0" allowfullscreen></iframe>

											<?php } ?> <span class="overlay"></span>
                                    
                                        </figure>

                                    <h4><?php the_title();?> <span> | <?php echo $term_slugs; ?></span></h4>

    					        </a>

                            </li>

                            <?php $i++; endwhile; } wp_reset_query(); ?>

                        </ul>

                    </div>
                      
                    </div>

                    </div>

                </main>

            </div>

    </section>

<?php get_footer(); ?>