<?php
/* Template Name: Member Page */

get_header();
get_template_part('templates/page-header');
?>

<section class="content-block">
    <div class="container">
        <div class="row">
            <div class="col-md-3 col-sm-4 content-left sidebar">
                <?php get_template_part( 'sections/sidebar-forms' ); ?>
            </div>

            <div class="col-md-9 col-sm-8 content-right main-content">
                <?php the_content();?>

                <main class="cd-main-content">
                    <div class="project-block cd-gallery">
                        <ul>
                            <?php
                            $custom_post_type = 'team';

                            $args = array(
                            'post_type'         =>  $custom_post_type,
                            'post_status'       =>  'publish',
                            'posts_per_page'    =>  -1,
                            'caller_get_posts'  =>  1,
                            'orderby'           =>  'date',
                            'order'             =>  'ASC',
                            );

                            $my_query = new WP_Query($args);
                            ?>

                            <?php if ( $my_query->have_posts() ) : $i = 1; while ( $my_query->have_posts() ) : $my_query->the_post(); ?>
                                <li class="col-md-6 col-sm-6 col-xs-6 block mix" >
                                    <a href="#popup<?php echo $i ; ?>" rel=”lightbox” data-lightbox-type="inline">
                                        <figure class="image-fill"><?php the_post_thumbnail('medium'); ?>
                                            <span class="overlay"></span>
                                        </figure>

                                        <h4><?php the_title(); ?></h4>
                                    </a>
                                </li>
                            <?php $i++; endwhile; endif; wp_reset_query(); ?>
                        </ul>
                    </div>
                </main>
            </div>
        </div>
    </div>
</section>

<?php
$custom_post_type = 'team';

$args = array(
'post_type'         =>  $custom_post_type,
'post_status'       =>  'publish',
'posts_per_page'    =>  -1,
'caller_get_posts'  =>  1,
'orderby'           =>  'date',
'order'             =>  'ASC'
);

$my_query = new WP_Query($args);
?>

<?php if ( $my_query->have_posts() ) : $i = 1; while ( $my_query->have_posts() ) : $my_query->the_post(); ?>
    <div id="popup<?php echo $i ; ?>" class="popup-window" style="display: none;">
                    <h4 class="title" ><?php the_title(); ?></h4>
                    <?php the_content(); ?>
    </div>
<?php $i++; endwhile; endif; wp_reset_query(); ?>

<?php get_footer(); ?>