<?php
/* Template Name: Services Page (Right Sidebar) */

get_header();
get_template_part('templates/page-header');
?>

<section class="content-block">
    <div class="container">
        <div class="row">
            <div class="content-right service">
                <div class="col-md-9 col-sm-8 content-right main-content">
                    <div class="news-list">
                        <?php
                        $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
                        $custom_args = array(
                        'post_type' => 'service',
                        'posts_per_page' => 5,
                        'paged' => $paged
                        );

                        $custom_query = new WP_Query( $custom_args );
                        ?>

                        <?php if ( $custom_query -> have_posts() ) : ?>
                            <?php while ( $custom_query -> have_posts() ) : $custom_query -> the_post(); ?>
                                <div class="block">
                                    <div class="text">
                                        <?php if ( get_field('plan_type', 'option') == '10 Page' ) : ?>
                                            <h2><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h2>
                                        <?php else : ?>
                                            <h2><a><?php the_title();?></a></h2>
                                        <?php endif; ?>

                                        <?php if ( get_field('plan_type', 'option') == '10 Page' ) : ?>
                                      
                                            <?php the_excerpt(); ?>
                                      
                                        <?php else : ?>
                                      
                                            <?php the_content(); ?>
                                      
                                            <?php if ( have_rows('service_listing') ): ?>
                                                <div class="services">
                                                  <ul>
                                                    <?php while(has_sub_field('service_listing')): ?>
                                                      <li>
                                                        <?php if ( get_sub_field('service_list_title') ) : ?>
                                                          <h6><?php the_sub_field('service_list_title')?></h6>
                                                        <?php endif; ?>

                                                        <?php the_sub_field('service_list_item')?>
                                                      </li>
                                                    <?php endwhile; ?>
                                                  </ul>
                                                </div>
                                              <?php endif; ?>
                            
                                              <?php $image_ids = get_field('service_gallery', false, false);
                                                if(!empty($image_ids)) {
                                                $shortcode = '[gallery ids="' . implode(',', $image_ids) . '"]';
                                                echo do_shortcode( $shortcode ); } ?>                                        
                                      
                                        <?php endif; ?>    

                                        <?php if ( get_field('plan_type', 'option') == '10 Page' ) : ?>
                                            <a href="<?php the_permalink(); ?>" class="btn hvr-sweep-to-right">Learn More</a>
                                            <div class="clear"></div>
                                        <?php else : ?>
                                            <div class="clear"></div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endwhile; ?>

                            <?php
                            if ( function_exists(custom_pagination) ) {
                                custom_pagination( $custom_query -> max_num_pages, "", $paged );
                            }
                            ?>

                            <?php wp_reset_postdata(); ?>
                        <?php else : ?>
                            <p><?php _e( 'Sorry, no posts matched your criteria.' ); ?></p>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-md-3 col-sm-4 content-left sidebar">
                    <?php get_template_part( 'sections/sidebar-menu' ); ?>
                    <?php get_template_part( 'sections/sidebar-forms' ); ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>